/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.web.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.creeperhost.minetogether.lib.web.EngineRequest;
import net.creeperhost.minetogether.lib.web.HeaderList;
import net.creeperhost.minetogether.lib.web.WebBody;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.Nullable;

public class OkHttpEngineRequest
implements EngineRequest {
    @Nullable
    private Request.Builder builder;
    @Nullable
    private String url;
    private final HeaderList headers = new HeaderList();

    @Override
    public EngineRequest method(String method, final @Nullable WebBody body) {
        assert (this.builder == null) : "Method already set.";
        this.builder = new Request.Builder();
        RequestBody reqBody = null;
        if (body != null) {
            String contentTypeStr = body.contentType();
            final MediaType contentType = contentTypeStr != null ? MediaType.parse((String)contentTypeStr) : null;
            reqBody = new RequestBody(){

                public void writeTo(BufferedSink dst) throws IOException {
                    try (Source src = Okio.source((InputStream)body.open());){
                        dst.writeAll(src);
                    }
                }

                @Nullable
                public MediaType contentType() {
                    return contentType;
                }

                public long contentLength() {
                    return body.length();
                }

                public boolean isOneShot() {
                    return true;
                }
            };
        }
        this.builder.method(method, reqBody);
        return this;
    }

    @Override
    public EngineRequest url(String url) {
        assert (this.builder != null) : "method(String, Body) must be called first";
        this.url = url;
        this.builder.url(url);
        return this;
    }

    @Override
    public EngineRequest header(String key, String value) {
        assert (this.builder != null) : "method(String, Body) must be called first";
        this.headers.add(key, value);
        return this;
    }

    @Override
    public EngineRequest headers(Map<String, String> headers) {
        assert (this.builder != null) : "method(String, Body) must be called first";
        this.headers.addAll(headers);
        return this;
    }

    @Override
    public EngineRequest headers(HeaderList headers) {
        assert (this.builder != null) : "method(String, Body) must be called first";
        this.headers.addAll(headers);
        return this;
    }

    @Override
    public EngineRequest removeHeader(String key) {
        assert (this.builder != null) : "method(String, Body) must be called first";
        this.headers.removeAll(key);
        return this;
    }

    @Override
    public String getUrl() {
        assert (this.builder != null) : "method(String, Body) must be called first";
        assert (this.url != null) : "Url not set";
        return this.url;
    }

    @Override
    public HeaderList getHeaders() {
        assert (this.builder != null) : "method(String, Body) must be called first";
        return this.headers;
    }

    public Request build() {
        assert (this.builder != null) : "method(String, Body) must be called first";
        assert (this.url != null) : "Url not set";
        for (HeaderList.Entry header : this.headers) {
            this.builder.addHeader(header.name, header.value);
        }
        return this.builder.build();
    }
}

